/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app;

import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.ZoomPanel;
import DE.siemens.ad.logo.model.ZoomIfc;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ZoomManager
implements ZoomIfc {
    public static final String ZOOM_CHANGED_PROPERTY_NAME = "zoom";
    protected static int[] zoomValues = new int[]{25, 50, 75, 100, 150, 200, 250, 300, 400};
    public static int MIN_ZOOM = zoomValues[0];
    public static int MAX_ZOOM = zoomValues[zoomValues.length - 1];
    private PropertyChangeSupport fPropertyChangeSupport;
    private Point fZoomAnchor;
    public int fCurrentZoom;
    public LogoDrawingView view;

    public ZoomManager(LogoDrawingView view) {
        this.view = view;
        LogoComfort logoComfort = (LogoComfort)view.editor();
        this.fCurrentZoom = 100;
        this.fPropertyChangeSupport = new PropertyChangeSupport(this);
    }

    protected void activateDeactivateZoomActions() {
        ActionFactory actionFactory = ((LogoComfort)this.view.editor()).getActionManager().getActionFactory();
        actionFactory.getAction("ZoomOutAction").setActivated(this.getZoom() != MIN_ZOOM);
        actionFactory.getAction("ZoomInAction").setActivated(this.getZoom() != MAX_ZOOM);
    }

    private void changeZoom() {
        LogoComfort logoComfort = (LogoComfort)this.view.editor();
        logoComfort.setZoomValue(this.fCurrentZoom);
        this.view.invalidate();
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.view);
        if (window != null) {
            window.validate();
        }
    }

    public int getZoom() {
        return this.fCurrentZoom;
    }

    public void setZoom(int newZoom) {
        if (newZoom >= MIN_ZOOM && newZoom <= MAX_ZOOM) {
            double oldZoomFator = (double)this.fCurrentZoom / 100.0;
            Point zoomAnchor = this.getZoomAnchor();
            Point zoomAnchorInDrawing = new Point((int)((double)zoomAnchor.x / oldZoomFator), (int)((double)zoomAnchor.y / oldZoomFator));
            Rectangle visibleViewRect = this.view.getVisibleRect();
            int oldZoom = this.fCurrentZoom;
            this.fCurrentZoom = newZoom;
            this.changeZoom();
            this.activateDeactivateZoomActions();
            this.firePropertyChange(ZOOM_CHANGED_PROPERTY_NAME, oldZoom, newZoom);
            double newZoomFactor = (double)newZoom / 100.0;
            Rectangle newVisibleRect = new Rectangle((int)((double)zoomAnchorInDrawing.x * newZoomFactor), (int)((double)zoomAnchorInDrawing.y * newZoomFactor), visibleViewRect.width, visibleViewRect.height);
            this.view.scrollRectToVisible(newVisibleRect);
        }
    }

    public void showZoomDlg() {
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.view);
        ZoomPanel zoomPanel = new ZoomPanel(this);
        SplittedDlg zoomDialog = SplittedDlg.create(frame, zoomPanel, 11);
        zoomDialog.show();
    }

    public void zoomIn() {
        for (int i = 0; i < zoomValues.length; ++i) {
            if (zoomValues[i] <= this.fCurrentZoom) continue;
            this.setZoom(zoomValues[i]);
            break;
        }
        this.activateDeactivateZoomActions();
    }

    public void zoomOut() {
        for (int i = zoomValues.length - 1; i >= 0; --i) {
            if (zoomValues[i] >= this.fCurrentZoom) continue;
            this.setZoom(zoomValues[i]);
            break;
        }
        this.activateDeactivateZoomActions();
    }

    public Point convertModelToDisplayCoordinates(Point modelPoint) {
        double zoomFactor = (double)this.fCurrentZoom / 100.0;
        Point displayPoint = new Point((int)((double)modelPoint.x * zoomFactor), (int)((double)modelPoint.y * zoomFactor));
        return displayPoint;
    }

    public Point convertDisplayToModelCoordinates(Point displayPoint) {
        double zoomFactor = (double)this.fCurrentZoom / 100.0;
        Point modelPoint = new Point((int)((double)displayPoint.x / zoomFactor), (int)((double)displayPoint.y / zoomFactor));
        return modelPoint;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.fPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.fPropertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.fPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    public Point getZoomAnchor() {
        if (this.fZoomAnchor == null) {
            Rectangle visibleRect = this.view.getVisibleRect();
            return new Point(visibleRect.x, visibleRect.y);
        }
        return this.fZoomAnchor;
    }

    public void setZoomAnchor(Point point) {
        this.fZoomAnchor = point;
    }
}

